#!/bin/sh

mkdir -p /media/bootupdate
if [ ! -f /media/usb/bootupdate.squashfs ]; then
	echo "bootupdate.squashfs was not found."
	exit 1
fi

if mount -t squashfs -o ro /media/usb/bootupdate.squashfs /media/bootupdate ; then
	echo "bootupdate.squashfs mounted successfully."
else
	echo "bootupdate.squashfs seems to be corrupt. Unable to update."
	exit 1
fi

if [ -e /dev/mmcblk0p2 ]; then
	# This SD card likely contains a previous SYMPL Core S image.
	echo "Found an SD card with a layout used by previous versions of the SYMPL Core S. Reformatting."

	(
		echo o     # Create a new empty DOS partition table
		echo n     # Add a new partition
		echo p     # Primary partition
		echo 1     # Partition number
		echo 8192  # First sector (8192 for SD cards)
		echo       # Last sector (use the default to cover the whole SD card)
		echo t     # Set the partition type
		echo c     # Set the partition type to FAT32 (LBA)
		echo w     # Write changes
	) | fdisk /dev/mmcblk0
	
	# mkfs.fat has moved to /sbin in newer images.
	if [ -e /usr/sbin/mkfs.fat ]; then
		/usr/sbin/mkfs.fat /dev/mmcblk0p1
	fi
	
	if [ -e /sbin/mkfs.fat ]; then
		/sbin/mkfs.fat /dev/mmcblk0p1
	fi
fi

mount -t vfat -o rw,fmask=0022,dmask=0022,utf8=true /dev/mmcblk0p1 /boot
mkdir -p /boot/data/config

# The update script used for the web based update can be used here as well.
if [ -f /media/bootupdate/sympl_core_s_boot_update.sh ]; then
	echo "Applying root image..."
	cp /media/bootupdate/sympl_core_s_boot_update.sh /media
	chmod +x /media/sympl_core_s_boot_update.sh
	/media/sympl_core_s_boot_update.sh
fi
sync
umount /media/bootupdate

# Remove old applications and copy new ones.
echo "Removing old applications..."
rm /boot/system/sys_*
rm /boot/system/app_*
rm /boot/system/update_*
echo "Copying new applications..."
cp /media/usb/update_*.squashfs /boot/system
sync

# Done.
umount /boot
echo b > /proc/sysrq-trigger
